<?php
/**
 * Custom Product wrapper class for shipping calculations.
 *
 * @package OpenApp_Payment_Gateway
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class OPENAPPGW_CustomProduct
 *
 * Helper class that wraps product data for shipping calculations.
 */
class OPENAPPGW_CustomProduct {
    private $name;
    private $shippingClass;
    private $weight;
    private $needsShipping;

    public function __construct($productArray) {
        $this->name = isset($productArray['name']) ? $productArray['name'] : '';
        $this->shippingClass = isset($productArray['shippingClass']) ? $productArray['shippingClass'] : '';
        $this->weight = isset($productArray['weight']) ? $productArray['weight'] : 0;
        $this->needsShipping = isset($productArray['needsShipping']) ? $productArray['needsShipping'] : false;
    }

    public function get_name() {
        return $this->name;
    }
    public function get_weight() {
        return $this->weight;
    }
    public function needs_shipping(){
        return $this->needsShipping;
    }
    public function get_shipping_class(){
        return $this->shippingClass;
    }
}
