<?php
/**
 * Login Integration trait for OpenApp Gateway.
 *
 * @package OpenApp_Payment_Gateway
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Trait OPENAPPGW_Trait_Login_Integration
 *
 * Handles OpenApp login authentication and session management.
 */
trait OPENAPPGW_Trait_Login_Integration {

    public function set_guest_session(){

        $oaSetGuestSession = filter_input(INPUT_GET, 'oa-set-guest-session', FILTER_SANITIZE_NUMBER_INT);

        if($oaSetGuestSession && $oaSetGuestSession === '1'){
            if (!is_user_logged_in()) {
                if ( isset( WC()->session ) ) {
                    if ( !WC()->session->has_session() ) {
                        $this->log_debug("set_session_for_guest");
                        WC()->session->set_customer_session_cookie(true);

                        // user session is active
                        // rebuild data
                        $this->store_cart_in_db(true);
                    }
                }
            }
            $redirect_url = wp_get_referer() ? wp_get_referer() : home_url();
            wp_safe_redirect($redirect_url.'?oa-initialized=1');
            exit;
        }
    }


    public function oa_check_login(WP_REST_Request $request)
    {
        $cart_id = sanitize_text_field($request->get_param('cart_id'));

        $this->log_debug("oa_check_login");

        if (empty($cart_id)) {
            return $this->create_secure_response(['should_login' => false]);
        }

        // Verify cart ownership (prevents enumeration attacks)
        $cart_ownership = $this->verify_cart_ownership($cart_id);
        if (is_wp_error($cart_ownership)) {
            return $this->create_secure_response(['should_login' => false]);
        }

        // Check auth token from verified cart data
        if (isset($cart_ownership->oa_auth_token) && !empty($cart_ownership->oa_auth_token)) {
            $args = array(
                'meta_key'     => 'oa_auth_token',
                'meta_value'   => $cart_ownership->oa_auth_token,
                'meta_compare' => '=',
                'number'       => 1,
            );

            $users = get_users($args);

            if (!empty($users) && $user = $users[0]) {
                $this->log_debug("oa_check_login: ". $user->user_email);

                return $this->create_secure_response(['should_login' => true, 'redirect_url' => '/?oa-custom-login=1']);
            }
        }

        return $this->create_secure_response(['should_login' => false]);
    }

    public function oa_custom_login(){
        $oaCustomLogin = filter_input(INPUT_GET, 'oa-custom-login', FILTER_SANITIZE_NUMBER_INT);

        if($oaCustomLogin && $oaCustomLogin === "1"){

            $this->log_debug("INIT oa-custom-login..");

            // Redirect to my account page
            $myaccount_page_id = get_option( 'woocommerce_myaccount_page_id' );
            $myaccount_url = get_permalink( $myaccount_page_id );

            if ( is_user_logged_in() ) {
                // do nothing (?)
            }

            $sessionId = $this->get_session_id();
            $sessionId = $this->get_cart_id_by_session($sessionId);

            // check if oauth_token exists
            // if yes - use associated email to login current user
            global $wpdb;

            $cart_data = $wpdb->get_row(
                $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "oa_woocommerce_persistent_cart WHERE cart_id = %s", $sessionId)
            );


            if (is_null($cart_data)) {
                return new WP_REST_Response( "Session do not exists", 500 );
            }

            if(isset($cart_data->oa_auth_token) && !is_null($cart_data->oa_auth_token)){
                $args = array(
                    'meta_key'     => 'oa_auth_token',
                    'meta_value'   => $cart_data->oa_auth_token,
                    'meta_compare' => '=',
                    'number'       => 1,
                );

                $users = get_users($args);

                if (!empty($users)) {
                    $user = $users[0];

                    if ($user) {
                        wp_clear_auth_cookie();
                        wp_set_current_user($user->ID, $user->user_login);
                        wp_set_auth_cookie($user->ID);
                        do_action('wp_login', $user->user_login, $user);

                        $this->log_debug("oa-custom-login: ". $user->user_email);

                        // clear auth token
                        $wpdb->query(
                            $wpdb->prepare("UPDATE " . $wpdb->prefix . "oa_woocommerce_persistent_cart SET oa_auth_token = NULL WHERE cart_id = %s", $sessionId)
                        );


                        // Update last login time
                        update_user_meta( $user->ID, 'oa_last_login', time() );

                        // Redirect to account page if the login cookie is already set.
                        wp_safe_redirect($myaccount_url);
                        exit;
                    }
                }
            }

            wp_safe_redirect($myaccount_url);
            exit;
        }
    }

}
