<?php

class OpenappAPIRoutes
{
    public static final function getRoutes(): array
    {
        $routes =  [
            // external routes
            'module-ps_openapp-basket' => [
                'rule' => 'openapp/basket',
                'keywords' => [],
                'controller' => 'basket',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-basket_recalculate' => [
                'rule' => 'openapp/basket_recalculate',
                'keywords' => [],
                'controller' => 'basket_recalculate',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-order' => [
                'rule' => 'openapp/order',
                'keywords' => [],
                'controller' => 'order',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-orderreturnaction' => [
                'rule' => 'openapp/order-return-action',
                'keywords' => [],
                'controller' => 'orderreturnaction',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],

            // internal routes
            'module-ps_openapp-qr_code' => [
                'rule' => 'openapp/qr_code',
                'keywords' => [],
                'controller' => 'qrcode',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-oa_redirection' => [
                'rule' => 'openapp/oa_redirection',
                'keywords' => [],
                'controller' => 'oaredirection',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-oa_login' => [
                'rule' => 'openapp/oa_login',
                'keywords' => [],
                'controller' => 'oalogin',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-identity' => [
                'rule' => 'openapp/identity',
                'keywords' => [],
                'controller' => 'identity',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
            'module-ps_openapp-products' => [
                'rule' => 'openapp/products',
                'keywords' => [],
                'controller' => 'products',
                'params' => [
                    'fc' => 'module',
                    'module' => 'ps_openapp'
                ]
            ],
        ];

        return $routes;
    }
}
