<?php

require_once dirname(__FILE__) . '/../OpenappAbstractRESTController.php';

use Symfony\Component\HttpFoundation\Request;

/**
 * This REST endpoint adds a product to cart
 */
class ps_openappidentityModuleFrontController extends OpenappAbstractRESTController
{

    private $placeholder = 'xxxxxxxx';

    protected function processPostRequest()
    {
        $bodyRaw         = Tools::file_get_contents('php://input');
        $_POST           = json_decode($bodyRaw, true);
        $email           = Tools::getValue('email');
        $token           = Tools::getValue('token'); // cart_id

        $request = Request::createFromGlobals();
        $headers = $request->headers->all();


        /**
         * Log body request
         */

        $this->ct_custom_log("identity_body:");
        $json_post_data = json_encode($_POST, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        $this->ct_custom_log($json_post_data);


        $bodyHash = hash('sha256', $bodyRaw, true);
        $responseBodyHashBase64 = base64_encode($bodyHash);
        $validHmac = $this->isRequestValid($headers, $responseBodyHashBase64);
        if(!$validHmac){
            $this->sendError('invalid_auth', $this->translator->trans('Unauthorized request', [], 'Modules.Openapp.Errors'), 403);
        }

        // validate email and token
        if(empty($email) || empty($token)){
            $this->sendError('missing_email_token', 'Incorrect parameters', 400);
        }

        $table_name       = _DB_PREFIX_.'ps_oa_persistent_cart';
        $token_safe       = pSQL($token);
        $query            = "SELECT * FROM `".$table_name."` WHERE `cart_id` = '$token_safe' ";
        $exec             = Db::getInstance()->executeS($query);

        $auth_token = \Tools::passwdGen(32);

        if( $exec ) {

            $customerIsValid = false;

            // check if customer exist
            $customer_id = Customer::customerExists($email, true);
            if( $customer_id )
            {
                $customerIsValid = true;
            } else {

                // create a new customer
                $randomPassword = \Tools::passwdGen(15);

                $guestAllowedCheckout = Configuration::get('PS_GUEST_CHECKOUT_ENABLED');
                $cp = new CustomerPersister(
                    $this->context,
                    $this->get('hashing'),
                    $this->getTranslator(),
                    $guestAllowedCheckout
                );

                $new_customer            = new Customer();
                $new_customer->firstname = $this->placeholder;
                $new_customer->lastname  = $this->placeholder;
                $new_customer->email     = $email;
                $new_customer->passwd    = $randomPassword;
                $new_customer->id_shop   = (int)$this->context->shop->id;

                $save = $cp->save($new_customer, $new_customer->passwd);

                if($save)
                {
                    $customerIsValid = true;
                    $customer_id = $new_customer->id;

                } else {
                    $this->sendError('error_creating_user', $this->trans('Unable to create user', [], 'Modules.Openapp.Errors'), 400);
                }
            }

            if($customerIsValid){
                Configuration::updateValue('OA_AUTH_TOKEN_' . $customer_id, $auth_token);
                $auth_token_safe = pSQL($auth_token);
                Db::getInstance()->Execute( "UPDATE `".$table_name."` SET `oa_auth_token` = '$auth_token_safe' WHERE `cart_id` = '$token_safe' " );
            }

            // Calculate X-Server-Authorization and set the header if it exists
            $expectedXServerAuth = $this->calculate_server_authorization($headers, null);

            if($expectedXServerAuth !== null) {
                header('X-Server-Authorization: '.$expectedXServerAuth);
            }

            http_response_code(200);
            die();
        }

        $this->sendError('token_not_exists', $this->trans('User token not exists in db', [], 'Modules.Openapp.Errors'), 400);
    }





}
