<?php
require_once dirname(__FILE__) . '/../OpenappAbstractRESTController.php';

class ps_openappoaredirectionModuleFrontController extends OpenappAbstractRESTController
{
    protected function processGetRequest()
    {
        $cart_id = pSQL(Tools::getValue('cart_id'));
        $lang_id    = (int) Configuration::get('PS_LANG_DEFAULT');

        $validate_cart = new Cart($cart_id, false, $lang_id);

        if ( Validate::isLoadedObject($validate_cart) || !is_null( $cart_id )  ) {

            $table_name = _DB_PREFIX_.'ps_oa_persistent_cart';
            $query = "SELECT order_key FROM `".$table_name."` WHERE `cart_id` = '$cart_id' ";
            $exec = Db::getInstance()->executeS($query);

            $order_key = isset($exec[0]['order_key']) ? $exec[0]['order_key'] : null;

            // Check that $order_key is neither null nor an empty string
            if (!empty($order_key)) {
                $orderId = Order::getByReference($order_key)->getFirst()->id;
                $order = new Order($orderId);

                if (Validate::isLoadedObject($order)) {
                    $paymentModuleName = $order->module;
                    $paymentModule = Module::getInstanceByName($paymentModuleName);
                    $paymentModuleId = $paymentModule->id;

                    $customer = new Customer($order->id_customer);

                    if (Validate::isLoadedObject($customer)) {
                        if (!$this->context->customer->isLogged()) {
                            if (version_compare(_PS_VERSION_, '1.7', '>=') && version_compare(_PS_VERSION_, '1.8', '<')) {
                                $this->loginUserById($order->id_customer);
                            }
                        }

                        $secureKey = $customer->secure_key;
                        $shopUrl = $this->context->link->getPageLink('order-confirmation');

                        $params = [
                            'id_cart' => (int)$cart_id,
                            'id_module' => (int)$paymentModuleId,
                            'id_order' => (int)$orderId,
                            'key' => $secureKey,
                        ];

                        $url = $shopUrl . '?' . http_build_query($params);

                        $this->ajaxRender($this->encodeJsonResponse([
                            'redirect' => true,
                            'url' => $url,
                        ]));
                        die;

                    }
                }
            }

        }


        $this->error();
    }

    private function loginUserById($customerId) {
        $customer = new Customer((int)$customerId);
        if (Validate::isLoadedObject($customer)) {
            $this->context->updateCustomer($customer);
        }
    }

    private function error(){
        $this->ajaxRender($this->encodeJsonResponse([
            'redirect' => false
        ]));
        die;
    }
}
