<?php
require_once dirname(__FILE__) . '/../OpenappAbstractRESTController.php';

use Symfony\Component\HttpFoundation\Request;

/**
 * Admin-triggered Accept/Reject for OpenApp returns
 *
 * POST /openapp/order-return-action
 */
class ps_openapporderreturnactionModuleFrontController extends OpenappAbstractRESTController
{
    protected function processPostRequest()
    {
        $request = Request::createFromGlobals();
        $token = Tools::getValue('token');
        $orderId = (int) Tools::getValue('orderId');
        $oaReturnId = Tools::getValue('oaReturnId');
        $action = Tools::getValue('returnAction'); // accept | reject
        $notes = Tools::getValue('notes', '');
        $employeeId = (int) Tools::getValue('employeeId');

        // Ensure employee context exists (FO controllers do not set it by default)
        if ((!$this->context->employee || !$this->context->employee->id) && $employeeId > 0) {
            $this->context->employee = new Employee($employeeId);
        }

        // Basic admin guard
        $expectedToken = Tools::getAdminTokenLite('AdminOrders');
        if (!$this->context->employee || !$this->context->employee->id || $token !== $expectedToken) {
            $this->sendError('forbidden', $this->trans('Unauthorized', [], 'Modules.Openapp.Errors'), 403);
        }

        if (empty($oaReturnId) || empty($orderId) || !in_array($action, array('accept', 'reject'))) {
            $this->sendError('invalid_request', $this->trans('Missing or invalid parameters', [], 'Modules.Openapp.Errors'), 400);
        }

        $order = new Order($orderId);
        if (!Validate::isLoadedObject($order)) {
            $this->sendError('order_not_found', $this->trans('Order not found', [], 'Modules.Openapp.Errors'), 404);
        }

        $orderReturn = $this->findReturnByOaId($orderId, $oaReturnId);
        if (!$orderReturn || !Validate::isLoadedObject($orderReturn)) {
            $this->sendError('return_not_found', $this->trans('Return not found', [], 'Modules.Openapp.Errors'), 404);
        }

        $newStatus = ($action === 'accept') ? 'ACCEPTED' : 'REJECTED';
        $targetState = ($action === 'accept')
            ? (int) Configuration::get('OA_RETURN_STATE_ACCEPTED')
            : (int) Configuration::get('OA_RETURN_STATE_REJECTED');
        $receivedState = (int) Configuration::get('OA_RETURN_STATE_RECEIVED', 1);

        if ($orderReturn->state != $receivedState) {
            $this->sendError('invalid_state', $this->trans('Return already processed', [], 'Modules.Openapp.Errors'), 400);
        }

        $orderReturn->state = $targetState > 0 ? $targetState : $orderReturn->state;
        $orderReturn->save();

        $apiResponse = $this->update_return_status_in_openapp($oaReturnId, $newStatus, $notes, $orderId);
        if (!$apiResponse['success']) {
            // rollback local state
            $orderReturn->state = $receivedState;
            $orderReturn->save();
            $this->sendError('openapp_update_failed', $apiResponse['error'], 500);
        }

        if ($action === 'accept') {
            $this->addActionOrderNote($order, 'Return accepted via OpenApp', $notes);
        } else {
            $this->addActionOrderNote($order, 'Return rejected via OpenApp', $notes);
        }

        $this->ajaxRender($this->encodeJsonResponse(array(
            'success' => true,
            'status' => $newStatus,
        )));
        die;
    }

    private function addActionOrderNote($order, $title, $notes)
    {
        $message = "=== " . $title . " ===\n";
        if (!empty($notes)) {
            $message .= "Notes: " . $notes . "\n";
        }

        $this->addPrivateOrderMessage($order, $message);
    }

    private function findReturnByOaId($orderId, $oaReturnId)
    {
        $sql = new DbQuery();
        $sql->select('id_order_return');
        $sql->from('order_return');
        $sql->where('id_order = ' . (int) $orderId);
        $sql->where("question LIKE '%" . pSQL($oaReturnId) . "%'");

        $row = Db::getInstance()->getRow($sql);
        if (!$row) {
            return null;
        }

        return new OrderReturn((int) $row['id_order_return']);
    }
}
