<div class="card mt-2" id="view_order_openapp_returns_block">
  <div class="card-header">
    <h3 class="card-header-title">
      OpenApp Returns ({$openapp_returns|@count})
    </h3>
  </div>
  <div class="card-body">
    {if $openapp_returns|@count == 0}
      <p class="text-muted mb-0">No OpenApp returns for this order.</p>
    {else}
      {foreach from=$openapp_returns item=return name=returns}
        <div class="card mb-3{if $return.state == $openapp_received_state} border-warning{elseif $return.state_name == 'OA Accepted'} border-success{elseif $return.state_name == 'OA Rejected'} border-danger{/if}">
          <div class="card-header d-flex justify-content-between align-items-center">
            <div>
              {if $return.state == $openapp_received_state}
                <span class="badge badge-warning">Pending</span>
              {elseif $return.state_name == 'OA Accepted'}
                <span class="badge badge-success">{$return.state_name|escape:'htmlall':'UTF-8'}</span>
              {elseif $return.state_name == 'OA Rejected'}
                <span class="badge badge-danger">{$return.state_name|escape:'htmlall':'UTF-8'}</span>
              {else}
                <span class="badge badge-secondary">{$return.state_name|default:$return.state|escape:'htmlall':'UTF-8'}</span>
              {/if}
              <small class="text-muted ml-2">{$return.created_at|escape:'htmlall':'UTF-8'}</small>
            </div>
            {if $return.state == $openapp_received_state}
              <div>
                <button class="btn btn-sm btn-primary js-oa-return-action" data-action="accept" data-oa="{$return.oa_return_id|escape:'htmlall':'UTF-8'}" data-order="{$openapp_order->id|intval}">
                  Accept
                </button>
                <button class="btn btn-sm btn-outline-secondary js-oa-return-action" data-action="reject" data-oa="{$return.oa_return_id|escape:'htmlall':'UTF-8'}" data-order="{$openapp_order->id|intval}">
                  Reject
                </button>
              </div>
            {/if}
          </div>
          <div class="card-body">
            <div class="row mb-3">
              <div class="col-md-6">
                <p class="mb-1"><strong>Case:</strong> {$return.case_id|escape:'htmlall':'UTF-8'}</p>
                <p class="mb-1"><strong>OA Return ID:</strong> <code>{$return.oa_return_id|escape:'htmlall':'UTF-8'}</code></p>
              </div>
              <div class="col-md-6 text-right">
                <a href="{$return.admin_return_link|escape:'htmlall':'UTF-8'}" class="btn btn-sm btn-outline-secondary">
                  View in Merchandise Returns
                </a>
              </div>
            </div>

            {if isset($return.payload.returnedProducts) && $return.payload.returnedProducts|@count > 0}
              <table class="table">
                <thead>
                  <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Type</th>
                    <th>Reason</th>
                    <th>Line Price</th>
                  </tr>
                </thead>
                <tbody>
                  {foreach from=$return.payload.returnedProducts item=product}
                    <tr>
                      <td>
                        {if isset($product.displayName)}
                          {$product.displayName|escape:'htmlall':'UTF-8'}
                        {else}
                          {$product.id|default:$product.productId|escape:'htmlall':'UTF-8'}
                        {/if}
                        <div class="text-muted small">ID: {$product.id|default:$product.productId|escape:'htmlall':'UTF-8'}</div>
                      </td>
                      <td>{$product.returnedQuantity|default:$product.quantity|escape:'htmlall':'UTF-8'}</td>
                      <td><span class="badge badge-secondary">{$product.returnType|default:$product.type|escape:'htmlall':'UTF-8'}</span></td>
                      <td>{$product.reasonLabels.pl|default:$product.reason|default:'-'|escape:'htmlall':'UTF-8'}</td>
                      <td>{if isset($product.linePrice)}{($product.linePrice/100)|string_format:"%.2f"}{else}-{/if}</td>
                    </tr>
                    {if isset($product.notes) && $product.notes}
                      <tr>
                        <td colspan="5" class="text-muted"><em><i class="material-icons" style="font-size: 14px; vertical-align: middle;">notes</i> {$product.notes|escape:'htmlall':'UTF-8'}</em></td>
                      </tr>
                    {/if}
                  {/foreach}
                </tbody>
              </table>
            {/if}
          </div>
        </div>
      {/foreach}
    {/if}
  </div>
</div>

<script>
  (function () {
    const buttons = document.querySelectorAll('.js-oa-return-action');
    buttons.forEach(function (btn) {
      btn.addEventListener('click', function () {
        const action = btn.dataset.action;
        const oaReturnId = btn.dataset.oa;
        const orderId = btn.dataset.order;
        const notes = prompt('Add notes for this action (optional):') || '';
        btn.disabled = true;
        btn.textContent = 'Processing...';

        fetch('{$openapp_return_action_url|escape:'javascript'}', {
          method: 'POST',
          headers: {ldelim}'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'{rdelim},
          body: new URLSearchParams({ldelim}
            token: '{$openapp_admin_token|escape:'javascript'}',
            employeeId: '{$openapp_employee_id|intval}',
            oaReturnId: oaReturnId,
            orderId: orderId,
            returnAction: action,
            notes: notes
          {rdelim})
        }).then(function (res) { return res.json(); })
          .then(function (data) {
            if (data && data.success) {
              location.reload();
            } else {
              alert('Failed: ' + (data && data.message ? data.message : 'Unknown error'));
              btn.disabled = false;
              btn.textContent = action === 'accept' ? 'Accept' : 'Reject';
            }
          }).catch(function () {
            alert('Request failed.');
            btn.disabled = false;
            btn.textContent = action === 'accept' ? 'Accept' : 'Reject';
          });
      });
    });
  })();
</script>
